/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.selection.IRestrType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;
import edu.mit.jverbnet.data.selection.PrepRestrType;
import edu.mit.jverbnet.data.selection.SemRestrType;
import edu.mit.jverbnet.data.selection.SynRestrType;
import edu.mit.jverbnet.data.syntax.INounPhraseType;
import edu.mit.jverbnet.data.syntax.SyntaxArgDesc;
import edu.mit.jverbnet.data.syntax.SyntaxArgType;
import edu.mit.jverbnet.parse.SelRestrictionsHandler;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxArgDescHandler
extends MappedHandler<SyntaxArgDesc.SyntaxArgDescBuilder> {
    private final SyntaxArgType type;
    private String value;
    private INounPhraseType npType;
    private ISelRestrictions<? extends IRestrType> selRestrs;

    public SyntaxArgDescHandler(SyntaxArgType type) {
        this(null, null, type);
    }

    public SyntaxArgDescHandler(IHasParserHandler parent, SyntaxArgType type) {
        this(parent == null ? null : parent.getParser(), (ContentHandler)parent, type);
    }

    public SyntaxArgDescHandler(XMLReader parser, SyntaxArgType type) {
        this(parser, null, type);
    }

    public SyntaxArgDescHandler(XMLReader parser, ContentHandler parent, SyntaxArgType type) {
        super(parser, parent, type.getID());
        this.type = type;
    }

    @Override
    protected void initHandlerMap(Map<String, ContentHandler> map) {
        if (this.type == SyntaxArgType.NP) {
            SelRestrictionsHandler<SemRestrType> selRestrHandler = new SelRestrictionsHandler<SemRestrType>((IHasParserHandler)this, true, SemRestrType.class){

                @Override
                public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                    if (SyntaxArgDescHandler.this.selRestrs != null) {
                        throw new IllegalArgumentException("The selection restrictions have already been specified for this syntax argument");
                    }
                    SyntaxArgDescHandler.this.selRestrs = (ISelRestrictions)this.doGetElement();
                }
            };
            SelRestrictionsHandler<SynRestrType> semRestrHandler = new SelRestrictionsHandler<SynRestrType>((IHasParserHandler)this, false, SynRestrType.class){

                @Override
                public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                    if (SyntaxArgDescHandler.this.selRestrs != null) {
                        throw new IllegalArgumentException("The selection restrictions have already been specified for this syntax argument");
                    }
                    SyntaxArgDescHandler.this.selRestrs = (ISelRestrictions)this.doGetElement();
                }
            };
            map.put(selRestrHandler.getTag(), selRestrHandler);
            map.put(semRestrHandler.getTag(), semRestrHandler);
        }
        if (this.type == SyntaxArgType.PREP) {
            SelRestrictionsHandler<PrepRestrType> prepRestrHandler = new SelRestrictionsHandler<PrepRestrType>((IHasParserHandler)this, true, PrepRestrType.class){

                @Override
                public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                    if (SyntaxArgDescHandler.this.selRestrs != null) {
                        throw new IllegalArgumentException("The selection restrictions have already been specified for this syntax argument");
                    }
                    SyntaxArgDescHandler.this.selRestrs = (ISelRestrictions)this.doGetElement();
                }
            };
            map.put(prepRestrHandler.getTag(), prepRestrHandler);
        }
    }

    @Override
    protected void clearLocal() {
        this.value = null;
        this.npType = null;
        this.selRestrs = null;
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String value = attrs.getValue("value");
        value = this.type.getValueRule().checkValue(value);
        if (this.type == SyntaxArgType.NP) {
            this.npType = VerbnetTypes.getNounPhraseTypeById(value);
        }
        this.value = value;
    }

    @Override
    public SyntaxArgDesc.SyntaxArgDescBuilder doGetElement() {
        return new SyntaxArgDesc.SyntaxArgDescBuilder(this.type, this.value, this.npType, this.selRestrs);
    }
}

