/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.semantics;

import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.semantics.ArgType;
import edu.mit.jverbnet.data.semantics.ISemanticArgType;
import edu.mit.jverbnet.util.Checks;
import java.util.HashMap;
import java.util.Map;

public class ArgTypeConstant
implements ISemanticArgType {
    public static final String XSD_TYPE_NAME = "argConstantType";
    private final String id;
    private static final Map<String, ArgTypeConstant> idMap = new HashMap<String, ArgTypeConstant>();

    protected ArgTypeConstant(String id) {
        this.id = Checks.NotNullEmptyOrBlank.check("id", id);
    }

    public String getID() {
        return this.id;
    }

    public ArgType getArgType() {
        return ArgType.Constant;
    }

    public static ArgTypeConstant getById(String id) {
        Checks.NotNullEmptyOrBlank.check("id", id);
        ArgTypeConstant result = idMap.get(id.toLowerCase());
        if (result == null) {
            result = new ArgTypeConstant(id);
            idMap.put(id.toLowerCase(), result);
        }
        if (!result.getID().equals(id)) {
            VerbnetTypes.printIdNormalizationWarning(ArgTypeConstant.class, id);
        }
        return result;
    }
}

