/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.selection;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;
import edu.mit.jverbnet.util.Checks;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelRestrictions<T extends IVerbnetType>
implements ISelRestrictions<T> {
    private static final SelRestrictions<IVerbnetType> EMPTY_RESTRICTIONS = new SelRestrictions(null, null, null);
    private final ISelRestrictions.Logic logic;
    private final Map<T, Boolean> typeRestrs;
    private final List<ISelRestrictions<T>> subRestrs;

    public static <T extends IVerbnetType> SelRestrictions<T> emptyRestrictions() {
        return EMPTY_RESTRICTIONS;
    }

    public SelRestrictions(ISelRestrictions.Logic logic, Map<T, Boolean> typeRestrs, List<ISelRestrictions<T>> subRestrs) {
        typeRestrs = Checks.allKeysAndValuesAre(Checks.NotNull, "typeRestrs", typeRestrs, Checks.UnmodifiableMaskNullWithEmpty);
        subRestrs = Checks.allElementsAre(Checks.NotNull, "subRestrs", subRestrs, Checks.UnmodifiableMaskNullWithEmpty);
        int elements = typeRestrs.size() + subRestrs.size();
        if (logic != null && elements < 1) {
            throw new IllegalArgumentException("If the logic is non-null, there must be at least two restriction elements");
        }
        this.logic = logic;
        this.typeRestrs = typeRestrs;
        this.subRestrs = subRestrs;
    }

    @Override
    public ISelRestrictions.Logic getLogic() {
        return this.logic;
    }

    @Override
    public Map<T, Boolean> getTypeRestrictions() {
        return this.typeRestrs;
    }

    @Override
    public List<ISelRestrictions<T>> getSubSelRestrictions() {
        return this.subRestrs;
    }

    @Override
    public boolean isEmpty() {
        if (this.logic != null) {
            return false;
        }
        if (!this.typeRestrs.isEmpty()) {
            return false;
        }
        return this.subRestrs.isEmpty();
    }
}

