/***************************************************************************
* JVerbnet v1.1.0
* Copyright (c) 2012 Massachusetts Institute of Technology
* 
* JVerbnet is distributed under the terms of the Creative Commons 
* Attribution 3.0 Unported License, which means it may be freely used for 
* all purposes, as long as proper acknowledgment is made.  See the license 
* file included with this distribution for more details.
****************************************************************************/

package edu.mit.jverbnet.data.syntax;

import static edu.mit.jverbnet.util.Checks.NotNull;
import static edu.mit.jverbnet.util.Checks.UnmodifiableMaskNullWithEmpty;
import static edu.mit.jverbnet.util.Checks.allElementsAre;

import java.util.List;

/** 
 * Default implementation of {@link ISyntaxDesc}. 
 *
 * @author Mark A. Finlayson
 * @version 1.1.0
 * @since JVerbnet 1.0.0
 */
public class SyntaxDesc implements ISyntaxDesc {
	
	/** 
	 * Default empty syntax object.
	 *
	 * @since JVerbnet 1.0.0
	 */
	public static final SyntaxDesc EMPTY_SYNTAX = new SyntaxDesc(null, null);
	
	// unchanging fields
	private final List<ISyntaxArgDesc> args0;
	private final List<ISyntaxArgDesc> args1;

	/** 
	 * Creates a new syntax descriptor with the specified sets of arguments
	 * 
	 * @param args0 the list of first argument descriptors; may not contain <code>null</code>
	 * @param args1 the list of second argument descriptors; may not contain <code>null</code>
	 * @since JVerbnet 1.0.0
	 */
	public SyntaxDesc(List<ISyntaxArgDesc> args0, List<ISyntaxArgDesc> args1){
		// check arguments
		args0 = allElementsAre(NotNull, "args0", args0, UnmodifiableMaskNullWithEmpty);
		args1 = allElementsAre(NotNull, "args1", args1, UnmodifiableMaskNullWithEmpty);
		
		// assign fields
		this.args0 = args0;
		this.args1 = args1;
	}

	/* 
	 * (non-Javadoc) 
	 *
	 * @see edu.mit.jverbnet.data.syntax.ISyntaxDesc#getFirstDescriptor()
	 */
	public List<ISyntaxArgDesc> getFirstDescriptor() {
		return args0;
	}

	/* 
	 * (non-Javadoc) 
	 *
	 * @see edu.mit.jverbnet.data.syntax.ISyntaxDesc#getSecondDescriptor()
	 */
	public List<ISyntaxArgDesc> getSecondDescriptor() {
		return args1;
	}

}
