/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.index;

import edu.mit.jverbnet.data.IMember;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.IVersion;
import edu.mit.jverbnet.data.IWordnetKey;
import edu.mit.jverbnet.data.Version;
import edu.mit.jverbnet.index.IVerbIndex;
import edu.mit.jverbnet.parse.VerbClassHandler;
import edu.mit.jverbnet.util.AbstractHasLifecycle;
import edu.mit.jverbnet.util.ByteBufferInputStream;
import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.FilteringIterator;
import edu.mit.jverbnet.util.ResourceUtils;
import edu.mit.jverbnet.util.parse.NullErrorHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbIndex
extends AbstractHasLifecycle
implements IVerbIndex {
    private final URL url;
    private boolean isOpen = false;
    private ErrorHandler errorHandler = NullErrorHandler.getInstance();
    private IVersion version;
    private Map<String, IVerbClass> verbsById;
    private Map<IWordnetKey, Set<IMember>> membersByKeys;
    private Map<String, Set<IMember>> membersByGroups;
    private Set<IMember> membersWithNoKey;
    private Set<IMember> membersWithNoGroup;

    public VerbIndex(File file) {
        this(ResourceUtils.toURL(file));
    }

    public VerbIndex(URL url) {
        Checks.NotNull.check("url", url);
        this.url = url;
    }

    @Override
    public IVersion getVersion() {
        if (this.version == null) {
            this.version = this.determineVersion();
        }
        return this.version;
    }

    protected IVersion determineVersion() {
        String path = this.url.getPath();
        int idx = path.lastIndexOf(92);
        if (idx == -1) {
            return IVersion.UNKNOWN;
        }
        String verStr = path.substring(idx + 1);
        Version v = Version.parseVersionProtected(verStr);
        return v == null ? Version.UNKNOWN : v;
    }

    @Override
    protected boolean doOpen() throws IOException {
        Map<String, IVerbClass> verbsById = this.initVerbByIdMap();
        if (verbsById == null) {
            return false;
        }
        Map membersByKeys = new TreeMap();
        Map membersByGroups = new TreeMap();
        Set<IMember> membersWithNoKey = new LinkedHashSet();
        Set<IMember> membersWithNoGroup = new LinkedHashSet();
        for (IVerbClass vc : verbsById.values()) {
            for (IMember m : vc.getMembers()) {
                if (m.getWordnetTypes().isEmpty()) {
                    membersWithNoKey.add(m);
                } else {
                    for (IWordnetKey key : m.getWordnetTypes()) {
                        this.getSetForKey(membersByKeys, key).add(m);
                    }
                }
                if (m.getGroupings().isEmpty()) {
                    membersWithNoGroup.add(m);
                    continue;
                }
                for (String group : m.getGroupings()) {
                    this.getSetForKey(membersByGroups, group).add(m);
                }
            }
        }
        membersByKeys = this.compressAndMakeUnmodifiable(membersByKeys);
        membersByGroups = this.compressAndMakeUnmodifiable(membersByGroups);
        membersWithNoKey = Checks.UnmodifiableMaskNullWithEmpty.reallocate(membersWithNoKey);
        membersWithNoGroup = Checks.UnmodifiableMaskNullWithEmpty.reallocate(membersWithNoGroup);
        this.verbsById = verbsById;
        this.membersByKeys = membersByKeys;
        this.membersByGroups = membersByGroups;
        this.membersWithNoKey = membersWithNoKey;
        this.membersWithNoGroup = membersWithNoGroup;
        this.isOpen = true;
        return true;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh == null ? NullErrorHandler.getInstance() : eh;
    }

    protected Map<String, IVerbClass> initVerbByIdMap() throws IOException {
        final LinkedHashMap result = new LinkedHashMap();
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader();
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.setErrorHandler(this.errorHandler);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        VerbClassHandler handler = new VerbClassHandler(parser, true){

            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                this.putVerbClass((IVerbClass)this.getElement());
            }

            protected void putVerbClass(IVerbClass vc) {
                result.put(vc.getID(), vc);
                for (IVerbClass subvc : vc.getSubclasses()) {
                    this.putVerbClass(subvc);
                }
            }
        };
        parser.setContentHandler(handler);
        File file = ResourceUtils.toFileChecked(this.url);
        if (file == null || file.isFile()) {
            if (file == null) {
                if (this.parse(parser, new BufferedInputStream(this.url.openStream()), this.url.getPath())) {
                    // empty if block
                }
                return null;
            }
            if (this.parse(parser, new ByteBufferInputStream(file), file.getName())) {
                return null;
            }
        } else if (file.isDirectory()) {
            File[] xmlFiles;
            for (File xmlFile : xmlFiles = file.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".xml");
                }
            })) {
                if (!this.parse(parser, new ByteBufferInputStream(xmlFile), xmlFile.getName())) continue;
                return null;
            }
        } else {
            Checks.thisLineShouldNeverBeCalled();
        }
        return Collections.unmodifiableMap(new LinkedHashMap(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parse(XMLReader parser, InputStream in, String filename) throws IOException {
        try {
            parser.parse(new InputSource(in));
        }
        catch (Throwable t) {
            StringWriter sb = new StringWriter();
            sb.append("Parsing problem: ");
            sb.append(filename == null ? "unknown file" : filename);
            sb.append(" (version ");
            sb.append(this.getVersion().toString());
            sb.append(")");
            System.err.println(sb.toString());
            t.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            in.close();
        }
        return false;
    }

    protected <K, V> Set<V> getSetForKey(Map<K, Set<V>> map, K key) {
        Set<V> result = map.get(key);
        if (result == null) {
            result = new LinkedHashSet<V>();
            map.put(key, result);
        }
        return result;
    }

    protected <K, V> Map<K, Set<V>> compressAndMakeUnmodifiable(Map<K, Set<V>> map) {
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableSet(new LinkedHashSet(entry.getValue())));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected boolean doIsOpen() {
        return this.isOpen;
    }

    @Override
    protected void doClose() {
        this.isOpen = false;
        this.verbsById = null;
        this.membersByKeys = null;
        this.membersByGroups = null;
    }

    @Override
    public IVerbClass getVerb(String id) {
        this.checkOpen();
        Checks.NotNullEmptyOrBlank.check("id", id);
        return this.verbsById.get(id);
    }

    @Override
    public IVerbClass getRootVerb(String id) {
        IVerbClass verb = this.getVerb(id);
        return verb != null && verb.isRoot() ? verb : null;
    }

    @Override
    public Set<IMember> getMembers(IWordnetKey key) {
        this.checkOpen();
        if (key == null) {
            return this.membersWithNoKey;
        }
        Set<IMember> result = this.membersByKeys.get(key);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Set<IMember> getMembers(String grouping) {
        this.checkOpen();
        grouping = Checks.IsNullEmptyOrBlank.mask(grouping, null);
        if (grouping == null) {
            return this.membersWithNoGroup;
        }
        Set<IMember> result = this.membersByGroups.get(grouping);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Iterator<IVerbClass> iterator() {
        this.checkOpen();
        return this.verbsById.values().iterator();
    }

    @Override
    public Iterator<IVerbClass> iteratorRoots() {
        return new FilteringIterator<IVerbClass>(this.iterator()){

            @Override
            protected boolean include(IVerbClass e) {
                return e.isRoot();
            }
        };
    }

    @Override
    public Iterator<IWordnetKey> iteratorWordnetKeys() {
        this.checkOpen();
        return this.membersByKeys.keySet().iterator();
    }

    @Override
    public Iterator<String> iteratorGroups() {
        this.checkOpen();
        return this.membersByGroups.keySet().iterator();
    }
}

