/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IVersion;
import edu.mit.jverbnet.util.Checks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements IVersion {
    private static final Map<Integer, Version> versionCache = new HashMap<Integer, Version>();
    public static final Version ver31 = Version.getVersion(3, 1, 0);
    public static final Version ver32 = Version.getVersion(3, 2, 0);
    private final int major;
    private final int minor;
    private final int bugfix;
    private final String qualifier;
    private transient String toString;
    private static final Pattern periodPattern = Pattern.compile("\\Q.\\E");
    private static final Pattern digitPattern = Pattern.compile("\\d+");
    private static List<Version> versions;

    public Version(int major, int minor, int bugfix) {
        this(major, minor, bugfix, null);
    }

    public Version(int major, int minor, int bugfix, String qualifier) {
        qualifier = Version.checkVersion(major, minor, bugfix, qualifier);
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.qualifier = qualifier;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getBugfixVersion() {
        return this.bugfix;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        return Version.hashCode(this.major, this.minor, this.bugfix, this.qualifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.bugfix != other.bugfix) {
            return false;
        }
        return this.qualifier.equals(other.qualifier);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Version.makeVersionString(this.major, this.minor, this.bugfix, this.qualifier);
        }
        return this.toString;
    }

    @Override
    public int compareTo(IVersion o) {
        return Version.compare(this, o);
    }

    public static int compare(IVersion one, IVersion two) {
        Checks.NotNull.check("one", one);
        Checks.NotNull.check("two", two);
        int cmp = Double.compare(one.getMajorVersion(), two.getMajorVersion());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(one.getMinorVersion(), two.getMinorVersion());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(one.getBugfixVersion(), two.getBugfixVersion());
        if (cmp != 0) {
            return cmp;
        }
        return one.getQualifier().compareTo(two.getQualifier());
    }

    public static String checkVersion(int major, int minor, int bugfix, String qualifier) {
        Version.checkVersionNumber(major, minor, bugfix);
        return Version.checkQualifier(qualifier);
    }

    public static void checkVersionNumber(int major, int minor, int bugfix) {
        if (Version.isIllegalVersionNumber(major, minor, bugfix)) {
            throw new IllegalArgumentException("Illegal version number: " + Version.makeVersionString(major, minor, bugfix, null));
        }
    }

    public static String checkQualifier(String qualifier) {
        if (qualifier == null) {
            return "";
        }
        if (Version.isIllegalQualifier(qualifier)) {
            throw new IllegalArgumentException("Illegal version qualifier: " + qualifier);
        }
        return qualifier;
    }

    public static boolean isIllegalVersion(int major, int minor, int bugfix, String qualifier) {
        if (Version.isIllegalVersionNumber(major, minor, bugfix)) {
            return true;
        }
        return Version.isIllegalQualifier(qualifier);
    }

    public static boolean isIllegalVersionNumber(int major, int minor, int bugfix) {
        if (major < 0) {
            return true;
        }
        if (minor < 0) {
            return true;
        }
        return bugfix < 0;
    }

    public static boolean isIllegalQualifier(String qualifier) {
        for (int i = 0; i < qualifier.length(); ++i) {
            if (Character.isJavaIdentifierPart(qualifier.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static Version getVersion(int major, int minor, int bugfix) {
        return Version.getVersion(major, minor, bugfix, null);
    }

    public static Version getVersion(int major, int minor, int bugfix, String qualifier) {
        int hash = Version.hashCode(major, minor, bugfix, qualifier = Version.checkVersion(major, minor, bugfix, qualifier));
        Version version = versionCache.get(hash);
        if (version == null) {
            version = new Version(major, minor, bugfix, qualifier);
            versionCache.put(version.hashCode(), version);
        }
        return version;
    }

    public static String makeVersionString(int major, int minor, int bugfix, String qualifier) {
        boolean hasQualifier = (qualifier = Version.checkQualifier(qualifier)) != null && qualifier.length() > 0;
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(major));
        sb.append('.');
        sb.append(Integer.toString(minor));
        if (bugfix > 0 || hasQualifier) {
            sb.append('.');
            sb.append(Integer.toString(bugfix));
        }
        if (hasQualifier) {
            sb.append('.');
            sb.append(qualifier);
        }
        return sb.toString();
    }

    public static int hashCode(int major, int minor, int bugfix, String qualifier) {
        qualifier = Version.checkVersion(major, minor, bugfix, qualifier);
        int prime = 31;
        int result = 1;
        result = 31 * result + major;
        result = 31 * result + minor;
        result = 31 * result + bugfix;
        result = 31 * result + qualifier.hashCode();
        return result;
    }

    public static Version parseVersionProtected(CharSequence verStr) {
        if (verStr == null) {
            return null;
        }
        String[] parts = periodPattern.split(verStr);
        if (parts.length < 2 || parts.length > 4) {
            return null;
        }
        String majorStr = parts[0].trim();
        if (!digitPattern.matcher(majorStr).matches()) {
            return null;
        }
        int major = Integer.parseInt(majorStr);
        String minorStr = parts[1].trim();
        if (!digitPattern.matcher(minorStr).matches()) {
            return null;
        }
        int minor = Integer.parseInt(minorStr);
        int bugfix = 0;
        if (parts.length >= 3) {
            String bugfixStr = parts[2].trim();
            if (!digitPattern.matcher(bugfixStr).matches()) {
                return null;
            }
            bugfix = Integer.parseInt(bugfixStr);
        }
        if (Version.isIllegalVersionNumber(major, minor, bugfix)) {
            return null;
        }
        String qualifier = null;
        if (parts.length == 4 && Version.isIllegalQualifier(qualifier = parts[3].trim())) {
            return null;
        }
        return Version.getVersion(major, minor, bugfix, qualifier);
    }

    public static Version parseVersion(CharSequence verStr) {
        if (verStr == null) {
            throw new NullPointerException();
        }
        String[] parts = periodPattern.split(verStr);
        if (parts.length < 2 || parts.length > 4) {
            throw new IllegalArgumentException();
        }
        int major = Integer.parseInt(parts[0].trim());
        int minor = Integer.parseInt(parts[1].trim());
        int bugfix = parts.length < 3 ? 0 : Integer.parseInt(parts[2].trim());
        String qualifier = parts.length < 4 ? null : parts[3].trim();
        return Version.getVersion(major, minor, bugfix, qualifier);
    }

    public static List<Version> values() {
        if (versions == null) {
            Field[] fields = Version.class.getDeclaredFields();
            ArrayList<Field> instanceFields = new ArrayList<Field>();
            for (Field field : fields) {
                if (field.getGenericType() != Version.class) continue;
                instanceFields.add(field);
            }
            ArrayList<Version> hidden = new ArrayList<Version>(instanceFields.size());
            for (Field field : instanceFields) {
                try {
                    Version dataType = (Version)field.get(null);
                    if (dataType == null) continue;
                    hidden.add(dataType);
                }
                catch (IllegalAccessException e) {}
            }
            versions = Collections.unmodifiableList(hidden);
        }
        return versions;
    }
}

